% **********************************************************************************************************************
% =====================================  绘制模态振型 =====================================


DATA = readmatrix('model_displacement_towerheight_fraction.xlsx','Sheet','Sheet1');
H = DATA(:,1);            % Tower height fraction
ss1_Fixed =    DATA(:,2);
ss1_Floating = DATA(:,3);

fa1_Fixed =    DATA(:,4);
fa1_Floating = DATA(:,5);

ss2_Fixed =    DATA(:,6);
ss2_Floating = DATA(:,7);

fa2_Fixed =    DATA(:,8);
fa2_Floating = DATA(:,9);

h(1)=figure;

%[ha,pos]=tight_subplot(Nh,Nw,gap,marg_h,marg_w);
% ha 是坐标轴句柄，pos是每个坐标轴的原点与长宽
% Nh,Nw 可以认为是几行几列
% gap是子图的纵向和横向间距，gap(1)为纵向，gap(2)为横向
% marg_h是图件与上下边缘的距离，marg_h(1)为距下边缘的距离，marg_h(2)是距上边缘的距离
% marg_w 是图件与左右边缘的距离，marg_w(1)为距左边缘的距离，marg_w(2)是距右边缘的距离

% ha = tight_subplot(3,2,[.01 .03],[.1 .01],[.01 .01])
%  for ii = 1:6; axes(ha(ii)); plot(randn(10,ii)); end
%  set(ha(1:4),'XTickLabel',''); set(ha,'YTickLabel','')


% subplot(1,4,1); 
%subplot('Position',[X相对坐标,Y相对坐标,宽,高]);
subplot('Position',[0.09,0.2,0.18,0.625]);
%axes1 = axes('Position',[0.13 0.21551724137931 0.151872777856431 0.709482758620694]);
%hold(axes1,'on');
% ax1 = axes('Position',[0.13 0.21551724137931 0.151872777856431 0.709482758620694]);
% hold(ax1,'on');

plot(ss1_Fixed,H,'linewidth',1.5,'Color',[1,0.38,0]);
hold on
plot(-ss1_Floating,H,'--','linewidth',1.5,'Color',[0.12,0.56,1]);
axis([-0.06 0.12 0 1]);
xlabel('Modal displacement','FontName','Times new Roman','FontSize',15.55);   % ,'FontWeight','bold'
ylabel('Fractional tower height','FontName','Times new Roman','FontSize',18.55);% ,'FontWeight','bold'
set(gca,'XTick',-0.06:0.06:0.12);
set(gca,'XMinorTick','on'); ax=gca; ax.XAxis.MinorTickValues=-0.06:0.03:0.12;
set(gca,'YMinorTick','on'); ax=gca; ax.YAxis.MinorTickValues=0:0.05:1;
[t]=title('1^{st} side-side');
 t.FontSize = 15.55;
 t.FontWeight ="bold";
set(gca,'linewidth',1.2,'fontsize',15.55,'fontname','Times');
legend('Fixed','Floating','FontName','Times new Roman','fontsize',15.55,'Location','northwest'); 
% set(gca,'tickdir','out') % 刻度线朝外


%***************************************************
% 去掉右侧和上侧的刻度线
% box off
% ax2 = axes('Position',get(gca,'Position'),...
%     'XAxisLocation','top',...
%     'YAxisLocation','right',...
%     'Color','none',...
%     'XColor','k','YColor','k',...
%     'LineWidth',1.2);
% set(ax2,'YTick', []);
% set(ax2,'XTick', []);
% box on
%***************************************************
%**************************************************



% subplot(1,4,2);
subplot('Position',[0.305,0.2,0.18,0.625]);
%plot(fa1_Fixed,H,fa1_Floating,H);
set(gca,'yticklabel',[]);            %隐藏y轴的数字
% set(gca,'ytick',[])                %隐藏y轴的刻度
plot(fa1_Fixed,H,'linewidth',1.5,'Color',[1,0.38,0]);
hold on
plot(fa1_Floating,H,'--','linewidth',1.5,'Color',[0.12,0.56,1]);
axis([-0.060 0.12 0 1]);
xlabel('Modal displacement','FontName','Times new Roman','FontSize',15.55); % ,'FontWeight','bold'
% ylabel('Tower height fraction','FontName','Times new Roman','FontSize',15.55,'FontWeight','bold');%
set(gca,'XTick',-0.06:0.06:0.12);
set(gca,'XMinorTick','on'); ax=gca; ax.XAxis.MinorTickValues=-0.06:0.03:0.12;
set(gca,'YMinorTick','on'); ax=gca; ax.YAxis.MinorTickValues=0:0.05:1;
[t]=title('1^{st} fore-aft');
 t.FontSize = 15.55;
 t.FontWeight ="bold";
set(gca,'linewidth',1.2,'fontsize',15.55,'fontname','Times');
% legend('Fixed','Floating','FontName','Times new Roman','fontsize',15.55,'Location','northwest'); 



%subplot(1,4,3);
subplot('Position',[0.52,0.2,0.18,0.625]);

set(gca,'yticklabel',[]);            %隐藏y轴的数字
plot(ss2_Fixed,H,'linewidth',1.5,'Color',[1,0.38,0]);
hold on
plot(ss2_Floating,H,'--','linewidth',1.5,'Color',[0.12,0.56,1]);
axis([-0.04 0.0801 0 1]);
xlabel('Modal displacement','FontName','Times new Roman','FontSize',15.55); % ,'FontWeight','bold'
% ylabel('Tower height fraction','FontName','Times new Roman','FontSize',15.55,'FontWeight','bold');%

set(gca,'XMinorTick','on'); ax=gca; ax.XAxis.MinorTickValues=-0.04:0.02:0.08;
set(gca,'YMinorTick','on'); ax=gca; ax.YAxis.MinorTickValues=0:0.05:1;
[t]=title('2^{nd} side-to-side');
 t.FontSize = 15.55;
 t.FontWeight ="bold";
set(gca,'linewidth',1.2,'fontsize',15.55,'fontname','Times');
% legend('Fixed','Floating','FontName','Times new Roman','fontsize',15.55,'Location','northwest'); 



% subplot(1,4,4);
subplot('Position',[0.735,0.2,0.18,0.625]);
%plot(fa2_Fixed,H,fa2_Floating,H);
set(gca,'yticklabel',[]);            %隐藏y轴的数字
plot(fa2_Fixed,H,'linewidth',1.5,'Color',[1,0.38,0]);
hold on
plot(-fa2_Floating,H,'--','linewidth',1.5,'Color',[0.12,0.56,1]);
axis([-0.04 0.0801 0 1]);
xlabel('Modal displacement','FontName','Times new Roman','FontSize',15.55); % ,'FontWeight','bold'
% ylabel('Tower height fraction','FontName','Times new Roman','FontSize',15.55,'FontWeight','bold');%

set(gca,'XMinorTick','on'); ax=gca; ax.XAxis.MinorTickValues=-0.04:0.02:0.08;
set(gca,'YMinorTick','on'); ax=gca; ax.YAxis.MinorTickValues=0:0.05:1;
[t]=title('2^{nd} fore-aft');
 t.FontSize = 15.55;
 t.FontWeight ="bold";
set(gca,'linewidth',1.2,'fontsize',15.55,'fontname','Times');
% legend('Fixed','Floating','FontName','Times new Roman','fontsize',15.55,'Location','northwest'); 


%-------------------------------------------------------------------------------------------


% print 1.jpg -djpeg -r800

